Attribute VB_Name = "PartsList"
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'       This is a part of the source code for Pro/DESKTOP.
'       Copyright (C) 1999 Parametric Technology Corporation.
'       All rights reserved.
'
'       File:PartsList.bas
'
'       This utility creates a parts list table using data from a comma separated value file(.CSV).
'       The .CSV file, which acts as an input for this utility, must be created using the
'       Pro/DESKTOP's Product Structure dialog.
'       The script reads the .CSV file and creates a table in the drawing document.
'       The script creates two columns viz. "Quantity" and "Part Name" in the table.
'       The "Quantity" column represents the number of instances of a component in
'       an assembly while the Part Name column represents the Part's name.
'       The script creates the table at the top right hand side corner of the drawing document.

Option Explicit
Private app As ProDESKTOP
Private uc1 As userCommand
Private ext As IProDExtensibility

Const textHeight As Double = 0.0035
Const ColumnWidth As Double = 0.05
Const firstColumn As Integer = 0
Const secondColumn As Integer = 1

Public Sub OnStartUp()
    Set app = CreateObject("ProDESKTOP.Application")
    Set ext = app
    Set uc1 = ext.AddUserCommand(barDrawing, menuDrawingDrawing, -1, GetResourceString(55), "PartsList", "PartsList.AddTable")
    uc1.setIdentifier 1000
    uc1.setprompt GetResourceString(55)
    uc1.SetAccelerator "Ctrl+Shift+P"
End Sub

Public Sub OnCloseDown()
    Set app = GetApp
    Set ext = app
    Set uc1 = ext.GetUserCommand(barDrawing, menuDrawingDrawing, GetResourceString(55))
    ext.RemoveUserCommand uc1
End Sub

Public Sub AddTable()
    On Error GoTo errorHandler
    If app Is Nothing Then
        Set app = CreateObject("ProDESKTOP.Application")
    End If
    
    Dim FileName As String
    FileName = InputBox(GetResourceString(151))
    If FileName = "" Then Exit Sub
    
    Dim api As helm
    Set api = app.TakeHelm
    
    AddExtension FileName
    
    Dim doc As DrawingDocument, dwg As aDrawing
    
    On Error Resume Next
    Set doc = app.GetActiveDoc
    
    If Not doc Is Nothing Then
        Set dwg = doc.GetDrawing
    Else
        MsgBox GetResourceString(152)
        Exit Sub
    End If
    
    'Get the active sheet objet in current drawing
    Dim sheet As aSheet
    Set sheet = doc.GetActiveSheet
               
    Dim corner As zVector
    Set corner = app.GetClass("Vector").CreateVector(sheet.GetWidth - 2 * ColumnWidth, sheet.GetHeight, 0)

    Dim fn As Integer
    fn = FreeFile
    
    On Error GoTo FileDoesNotExist
    Open FileName For Input As #fn
    On Error GoTo 0
    
    Dim table As aTable
    Set table = CreateTable(sheet, corner)
    
    Dim part As String, quantity As Integer, pathName As String, i As Integer
    
    i = 0
    Do While Not EOF(fn)
        Input #fn, part, quantity, pathName
        writeToTable dwg, table, i, part, quantity
        i = i + 1
    Loop
    
    Close #fn
    
    api.CommitCalls "Add Table", False
    
    On Error GoTo 0
Exit Sub

errorHandler:
    MsgBox GetResourceString(96)
Exit Sub

FileDoesNotExist:
    MsgBox MakeString(GetResourceString(153), FileName)
End Sub

Private Function CreateTable(sheet As aSheet, corner As zVector) As aTable
    Dim table As aTable
    Dim nColumns As Integer
    Let nColumns = 2
        
    Set table = app.GetClass("Table").CreateTable(corner, textHeight, nColumns, ColumnWidth, alignCenter)
    sheet.AddTable table
    table.SetTitle firstColumn, GetResourceString(154)
    table.SetTitle secondColumn, GetResourceString(155)
    
    Set CreateTable = table
End Function
    
Private Function GetName(FileName As String) As String
    Dim pos As Integer
    pos = InStr(1, FileName, ".")
    If pos > 0 Then FileName = Left(FileName, pos - 1)
    
    GetName = UCase(FileName)
End Function

Private Sub AddExtension(FileName As String)
    Dim pos As Integer
    pos = InStr(1, FileName, ".")
    If pos = 0 Then FileName = FileName + ".csv"
End Sub

Private Function writeToTable(dwg As aDrawing, table As aTable, row As Integer, part As String, quantity As Integer)
    If row <> -1 Then
        table.InsertRow -1
    End If
    
    Dim cell As aTableCell
    Dim tableColumn As aTableColumn
    
    Set tableColumn = table.GetColumn(firstColumn)
    Set cell = tableColumn.GetCell(row)
    AddNote dwg, cell, CStr(quantity)
    
    Set tableColumn = table.GetColumn(secondColumn)
    Set cell = tableColumn.GetCell(row)
    AddNote dwg, cell, GetName(CStr(part))
End Function

Private Sub AddNote(dwg As aDrawing, cell As aTableCell, text As String)
    Dim note As aNote
    Dim callout As aCallout
    Dim group As aCalloutGroup
    
    Dim dummy As zVector
    Set dummy = app.GetClass("Vector").CreateVector(0, 0, 0)
    
    Set note = app.GetClass("Note").CreateNote(dwg, text)
    Set callout = app.GetClass("NoteCallout").CreateNoteCallout(note)
    Set group = app.GetClass("CalloutGroup").CreateCalloutGroup(callout, dummy, textHeight)
    cell.SetCalloutGroup group
End Sub

